/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherGameEvents;
import com.aetherteam.aether.advancement.AetherAdvancementTriggers;
import com.aetherteam.aether.api.AetherAdvancementSoundOverrides;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.attachment.AetherDataAttachments;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.AetherCauldronInteractions;
import com.aetherteam.aether.block.AetherWoodTypes;
import com.aetherteam.aether.block.dispenser.AetherDispenseBehaviors;
import com.aetherteam.aether.block.dispenser.DispenseUsableItemBehavior;
import com.aetherteam.aether.block.dispenser.SkyrootBoatDispenseBehavior;
import com.aetherteam.aether.blockentity.AetherBlockEntityTypes;
import com.aetherteam.aether.blockentity.TreasureChestBlockEntity;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.CombinedPackResources;
import com.aetherteam.aether.client.TriviaGenerator;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.command.AetherCommands;
import com.aetherteam.aether.command.SunAltarWhitelist;
import com.aetherteam.aether.data.ReloadListeners;
import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.data.resources.registries.AetherDataMaps;
import com.aetherteam.aether.data.resources.registries.AetherMoaTypes;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.ai.attribute.AetherAttributes;
import com.aetherteam.aether.event.hooks.AbilityHooks;
import com.aetherteam.aether.event.listeners.DimensionListener;
import com.aetherteam.aether.event.listeners.EntityListener;
import com.aetherteam.aether.event.listeners.PerkListener;
import com.aetherteam.aether.event.listeners.RecipeListener;
import com.aetherteam.aether.event.listeners.abilities.AccessoryAbilityListener;
import com.aetherteam.aether.event.listeners.abilities.ArmorAbilityListener;
import com.aetherteam.aether.event.listeners.abilities.ToolAbilityListener;
import com.aetherteam.aether.event.listeners.abilities.WeaponAbilityListener;
import com.aetherteam.aether.event.listeners.capability.AetherPlayerListener;
import com.aetherteam.aether.event.listeners.capability.AetherTimeListener;
import com.aetherteam.aether.inventory.AetherAccessorySlots;
import com.aetherteam.aether.inventory.AetherRecipeBookTypes;
import com.aetherteam.aether.inventory.menu.AetherMenuTypes;
import com.aetherteam.aether.item.AetherCreativeTabs;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.combat.AetherArmorMaterials;
import com.aetherteam.aether.item.combat.ZaniteSwordItem;
import com.aetherteam.aether.item.combat.loot.FlamingSwordItem;
import com.aetherteam.aether.item.combat.loot.HolySwordItem;
import com.aetherteam.aether.item.combat.loot.PigSlayerItem;
import com.aetherteam.aether.item.components.AetherDataComponents;
import com.aetherteam.aether.loot.conditions.AetherLootConditions;
import com.aetherteam.aether.loot.functions.AetherLootFunctions;
import com.aetherteam.aether.loot.modifiers.AetherLootTableModifications;
import com.aetherteam.aether.network.packet.AetherPlayerSyncPacket;
import com.aetherteam.aether.network.packet.AetherTimeSyncPacket;
import com.aetherteam.aether.network.packet.PhoenixArrowSyncPacket;
import com.aetherteam.aether.network.packet.clientbound.AetherTravelPacket;
import com.aetherteam.aether.network.packet.clientbound.BossInfoPacket;
import com.aetherteam.aether.network.packet.clientbound.ClientDeveloperGlowPacket;
import com.aetherteam.aether.network.packet.clientbound.ClientGrabItemPacket;
import com.aetherteam.aether.network.packet.clientbound.ClientHaloPacket;
import com.aetherteam.aether.network.packet.clientbound.ClientMoaSkinPacket;
import com.aetherteam.aether.network.packet.clientbound.CloudMinionPacket;
import com.aetherteam.aether.network.packet.clientbound.HealthResetPacket;
import com.aetherteam.aether.network.packet.clientbound.LeavingAetherPacket;
import com.aetherteam.aether.network.packet.clientbound.MoaInteractPacket;
import com.aetherteam.aether.network.packet.clientbound.OpenSunAltarPacket;
import com.aetherteam.aether.network.packet.clientbound.PortalInteractPacket;
import com.aetherteam.aether.network.packet.clientbound.PortalTravelSoundPacket;
import com.aetherteam.aether.network.packet.clientbound.QueenDialoguePacket;
import com.aetherteam.aether.network.packet.clientbound.RegisterMoaSkinsPacket;
import com.aetherteam.aether.network.packet.clientbound.RemountAerbunnyPacket;
import com.aetherteam.aether.network.packet.clientbound.SetInvisibilityPacket;
import com.aetherteam.aether.network.packet.clientbound.ToolDebuffPacket;
import com.aetherteam.aether.network.packet.clientbound.ZephyrSnowballHitPacket;
import com.aetherteam.aether.network.packet.serverbound.AerbunnyPuffPacket;
import com.aetherteam.aether.network.packet.serverbound.ClearItemPacket;
import com.aetherteam.aether.network.packet.serverbound.HammerProjectileLaunchPacket;
import com.aetherteam.aether.network.packet.serverbound.LoreExistsPacket;
import com.aetherteam.aether.network.packet.serverbound.NpcPlayerInteractPacket;
import com.aetherteam.aether.network.packet.serverbound.OpenAccessoriesPacket;
import com.aetherteam.aether.network.packet.serverbound.OpenInventoryPacket;
import com.aetherteam.aether.network.packet.serverbound.ServerDeveloperGlowPacket;
import com.aetherteam.aether.network.packet.serverbound.ServerHaloPacket;
import com.aetherteam.aether.network.packet.serverbound.ServerMoaSkinPacket;
import com.aetherteam.aether.network.packet.serverbound.StepHeightPacket;
import com.aetherteam.aether.network.packet.serverbound.SunAltarUpdatePacket;
import com.aetherteam.aether.recipe.AetherRecipeSerializers;
import com.aetherteam.aether.recipe.AetherRecipeTypes;
import com.aetherteam.aether.recipe.recipes.block.AmbrosiumRecipe;
import com.aetherteam.aether.recipe.recipes.block.SwetBallRecipe;
import com.aetherteam.aether.world.AetherPoi;
import com.aetherteam.aether.world.feature.AetherFeatures;
import com.aetherteam.aether.world.foliageplacer.AetherFoliagePlacerTypes;
import com.aetherteam.aether.world.placementmodifier.AetherPlacementModifiers;
import com.aetherteam.aether.world.processor.AetherStructureProcessors;
import com.aetherteam.aether.world.structure.AetherStructureTypes;
import com.aetherteam.aether.world.structurepiece.AetherStructurePieceTypes;
import com.aetherteam.aether.world.treedecorator.AetherTreeDecoratorTypes;
import com.aetherteam.aether.world.trunkplacer.AetherTrunkPlacerTypes;
import com.aetherteam.aetherfabric.AetherFabric;
import com.aetherteam.aetherfabric.NetworkRegisterHelper;
import com.aetherteam.aetherfabric.WrappedInventoryStorage;
import com.aetherteam.aetherfabric.events.AddPackFindersEvent;
import com.aetherteam.aetherfabric.events.ItemAttributeModifierHelper;
import com.aetherteam.aetherfabric.events.LivingEntityEvents;
import com.aetherteam.aetherfabric.registries.DeferredRegister;
import com.aetherteam.aetherfabric.registries.datamaps.RegisterDataMapTypesEvent;
import com.google.common.reflect.Reflection;
import com.mojang.logging.LogUtils;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeConfigRegistry;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.registry.FlattenableBlockRegistry;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.fabricmc.fabric.api.registry.TillableBlockRegistry;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2357;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2965;
import net.minecraft.class_3259;
import net.minecraft.class_3264;
import net.minecraft.class_3272;
import net.minecraft.class_3281;
import net.minecraft.class_3288;
import net.minecraft.class_5250;
import net.minecraft.class_5352;
import net.minecraft.class_5620;
import net.minecraft.class_7699;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import org.slf4j.Logger;

public class Aether
implements ModInitializer {
    public static final String MODID = "aether";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Path DIRECTORY = FabricLoader.getInstance().getConfigDir().resolve("aether");
    public static final TriviaGenerator TRIVIA_READER = new TriviaGenerator();

    public void onInitialize() {
        DeferredRegister[] registers;
        DIRECTORY.toFile().mkdirs();
        NeoForgeConfigRegistry.INSTANCE.register(MODID, ModConfig.Type.STARTUP, (IConfigSpec)AetherConfig.STARTUP_SPEC);
        NeoForgeConfigRegistry.INSTANCE.register(MODID, ModConfig.Type.SERVER, (IConfigSpec)AetherConfig.SERVER_SPEC);
        NeoForgeConfigRegistry.INSTANCE.register(MODID, ModConfig.Type.COMMON, (IConfigSpec)AetherConfig.COMMON_SPEC);
        NeoForgeConfigRegistry.INSTANCE.register(MODID, ModConfig.Type.CLIENT, (IConfigSpec)AetherConfig.CLIENT_SPEC);
        for (DeferredRegister register : registers = new DeferredRegister[]{AetherEntityTypes.ENTITY_TYPES, AetherDataComponents.DATA_COMPONENT_TYPES, AetherBlocks.BLOCKS, AetherItems.ITEMS, AetherAttributes.ATTRIBUTES, AetherBlockEntityTypes.BLOCK_ENTITY_TYPES, AetherMenuTypes.MENU_TYPES, AetherEffects.EFFECTS, AetherArmorMaterials.ARMOR_MATERIALS, AetherParticleTypes.PARTICLES, AetherFeatures.FEATURES, AetherFoliagePlacerTypes.FOLIAGE_PLACERS, AetherPlacementModifiers.PLACEMENT_MODIFIERS, AetherTrunkPlacerTypes.TRUNK_PLACERS, AetherTreeDecoratorTypes.TREE_DECORATORS, AetherStructureTypes.STRUCTURE_TYPES, AetherStructurePieceTypes.STRUCTURE_PIECE_TYPES, AetherStructureProcessors.STRUCTURE_PROCESSOR_TYPES, AetherRecipeTypes.RECIPE_TYPES, AetherRecipeSerializers.RECIPE_SERIALIZERS, AetherLootFunctions.LOOT_FUNCTION_TYPES, AetherLootConditions.LOOT_CONDITION_TYPES, AetherSoundEvents.SOUNDS, AetherGameEvents.GAME_EVENTS, AetherCreativeTabs.CREATIVE_MODE_TABS, AetherAdvancementSoundOverrides.ADVANCEMENT_SOUND_OVERRIDES, AetherAdvancementTriggers.TRIGGERS}) {
            register.addEntriesToRegistry();
        }
        AetherDataAttachments.init();
        AetherPoi.init();
        AetherWoodTypes.init();
        this.registerCapabilities();
        this.registerPackets();
        RegisterDataMapTypesEvent.EVENT.register(this::registerDataMaps);
        AddPackFindersEvent.EVENT.register(this::packSetup);
        DynamicRegistries.registerSynced(AetherMoaTypes.MOA_TYPE_REGISTRY_KEY, MoaType.CODEC, (DynamicRegistries.SyncOption[])new DynamicRegistries.SyncOption[0]);
        this.eventSetup();
        AetherBlocks.registerWoodTypes();
        Reflection.initialize((Class[])new Class[]{SunAltarWhitelist.class});
        Reflection.initialize((Class[])new Class[]{AetherRecipeBookTypes.class});
        Reflection.initialize((Class[])new Class[]{AetherMobCategory.class});
        Reflection.initialize((Class[])new Class[]{AetherAdvancementTriggers.class});
        AetherBlocks.registerPots();
        AetherBlocks.registerFlammability();
        AetherBlocks.registerFluidInteractions();
        AetherItems.registerAccessories();
        AetherItems.setupBucketReplacements();
        this.registerDispenserBehaviors();
        this.registerCauldronInteractions();
        UniqueSlotHandling.EVENT.register((Object)AetherAccessorySlots.INSTANCE);
        AetherFabric.init();
        AetherLootTableModifications.initLootModifiers();
    }

    public void registerPackets() {
        NetworkRegisterHelper registrar = NetworkRegisterHelper.INSTANCE;
        registrar.playToClient(AetherTravelPacket.TYPE, AetherTravelPacket.STREAM_CODEC, AetherTravelPacket::execute);
        registrar.playToClient(BossInfoPacket.Display.TYPE, BossInfoPacket.Display.STREAM_CODEC, BossInfoPacket.Display::execute);
        registrar.playToClient(BossInfoPacket.Remove.TYPE, BossInfoPacket.Remove.STREAM_CODEC, BossInfoPacket.Remove::execute);
        registrar.playToClient(ClientDeveloperGlowPacket.Apply.TYPE, ClientDeveloperGlowPacket.Apply.STREAM_CODEC, ClientDeveloperGlowPacket.Apply::execute);
        registrar.playToClient(ClientDeveloperGlowPacket.Remove.TYPE, ClientDeveloperGlowPacket.Remove.STREAM_CODEC, ClientDeveloperGlowPacket.Remove::execute);
        registrar.playToClient(ClientDeveloperGlowPacket.Sync.TYPE, ClientDeveloperGlowPacket.Sync.STREAM_CODEC, ClientDeveloperGlowPacket.Sync::execute);
        registrar.playToClient(ClientGrabItemPacket.TYPE, ClientGrabItemPacket.STREAM_CODEC, ClientGrabItemPacket::execute);
        registrar.playToClient(ClientHaloPacket.Apply.TYPE, ClientHaloPacket.Apply.STREAM_CODEC, ClientHaloPacket.Apply::execute);
        registrar.playToClient(ClientHaloPacket.Remove.TYPE, ClientHaloPacket.Remove.STREAM_CODEC, ClientHaloPacket.Remove::execute);
        registrar.playToClient(ClientHaloPacket.Sync.TYPE, ClientHaloPacket.Sync.STREAM_CODEC, ClientHaloPacket.Sync::execute);
        registrar.playToClient(ClientMoaSkinPacket.Apply.TYPE, ClientMoaSkinPacket.Apply.STREAM_CODEC, ClientMoaSkinPacket.Apply::execute);
        registrar.playToClient(ClientMoaSkinPacket.Remove.TYPE, ClientMoaSkinPacket.Remove.STREAM_CODEC, ClientMoaSkinPacket.Remove::execute);
        registrar.playToClient(ClientMoaSkinPacket.Sync.TYPE, ClientMoaSkinPacket.Sync.STREAM_CODEC, ClientMoaSkinPacket.Sync::execute);
        registrar.playToClient(CloudMinionPacket.TYPE, CloudMinionPacket.STREAM_CODEC, CloudMinionPacket::execute);
        registrar.playToClient(HealthResetPacket.TYPE, HealthResetPacket.STREAM_CODEC, HealthResetPacket::execute);
        registrar.playToClient(LeavingAetherPacket.TYPE, LeavingAetherPacket.STREAM_CODEC, LeavingAetherPacket::execute);
        registrar.playToClient(MoaInteractPacket.TYPE, MoaInteractPacket.STREAM_CODEC, MoaInteractPacket::execute);
        registrar.playToClient(OpenSunAltarPacket.TYPE, OpenSunAltarPacket.STREAM_CODEC, OpenSunAltarPacket::execute);
        registrar.playToClient(PortalInteractPacket.TYPE, PortalInteractPacket.STREAM_CODEC, PortalInteractPacket::execute);
        registrar.playToClient(PortalTravelSoundPacket.TYPE, PortalTravelSoundPacket.STREAM_CODEC, PortalTravelSoundPacket::execute);
        registrar.playToClient(QueenDialoguePacket.TYPE, QueenDialoguePacket.STREAM_CODEC, QueenDialoguePacket::execute);
        registrar.playToClient(RegisterMoaSkinsPacket.TYPE, RegisterMoaSkinsPacket.STREAM_CODEC, RegisterMoaSkinsPacket::execute);
        registrar.playToClient(RemountAerbunnyPacket.TYPE, RemountAerbunnyPacket.STREAM_CODEC, RemountAerbunnyPacket::execute);
        registrar.playToClient(SetInvisibilityPacket.TYPE, SetInvisibilityPacket.STREAM_CODEC, SetInvisibilityPacket::execute);
        registrar.playToClient(ToolDebuffPacket.TYPE, ToolDebuffPacket.STREAM_CODEC, ToolDebuffPacket::execute);
        registrar.playToClient(ZephyrSnowballHitPacket.TYPE, ZephyrSnowballHitPacket.STREAM_CODEC, ZephyrSnowballHitPacket::execute);
        registrar.playToServer(AerbunnyPuffPacket.TYPE, AerbunnyPuffPacket.STREAM_CODEC, AerbunnyPuffPacket::execute);
        registrar.playToServer(ClearItemPacket.TYPE, ClearItemPacket.STREAM_CODEC, ClearItemPacket::execute);
        registrar.playToServer(HammerProjectileLaunchPacket.TYPE, HammerProjectileLaunchPacket.STREAM_CODEC, HammerProjectileLaunchPacket::execute);
        registrar.playToServer(LoreExistsPacket.TYPE, LoreExistsPacket.STREAM_CODEC, LoreExistsPacket::execute);
        registrar.playToServer(NpcPlayerInteractPacket.TYPE, NpcPlayerInteractPacket.STREAM_CODEC, NpcPlayerInteractPacket::execute);
        registrar.playToServer(OpenAccessoriesPacket.TYPE, OpenAccessoriesPacket.STREAM_CODEC, OpenAccessoriesPacket::execute);
        registrar.playToServer(OpenInventoryPacket.TYPE, OpenInventoryPacket.STREAM_CODEC, OpenInventoryPacket::execute);
        registrar.playToServer(ServerDeveloperGlowPacket.Apply.TYPE, ServerDeveloperGlowPacket.Apply.STREAM_CODEC, ServerDeveloperGlowPacket.Apply::execute);
        registrar.playToServer(ServerDeveloperGlowPacket.Remove.TYPE, ServerDeveloperGlowPacket.Remove.STREAM_CODEC, ServerDeveloperGlowPacket.Remove::execute);
        registrar.playToServer(ServerHaloPacket.Apply.TYPE, ServerHaloPacket.Apply.STREAM_CODEC, ServerHaloPacket.Apply::execute);
        registrar.playToServer(ServerHaloPacket.Remove.TYPE, ServerHaloPacket.Remove.STREAM_CODEC, ServerHaloPacket.Remove::execute);
        registrar.playToServer(ServerMoaSkinPacket.Apply.TYPE, ServerMoaSkinPacket.Apply.STREAM_CODEC, ServerMoaSkinPacket.Apply::execute);
        registrar.playToServer(ServerMoaSkinPacket.Remove.TYPE, ServerMoaSkinPacket.Remove.STREAM_CODEC, ServerMoaSkinPacket.Remove::execute);
        registrar.playToServer(StepHeightPacket.TYPE, StepHeightPacket.STREAM_CODEC, StepHeightPacket::execute);
        registrar.playToServer(SunAltarUpdatePacket.TYPE, SunAltarUpdatePacket.STREAM_CODEC, SunAltarUpdatePacket::execute);
        registrar.playBidirectional(AetherPlayerSyncPacket.TYPE, AetherPlayerSyncPacket.STREAM_CODEC, AetherPlayerSyncPacket::execute);
        registrar.playBidirectional(AetherTimeSyncPacket.TYPE, AetherTimeSyncPacket.STREAM_CODEC, AetherTimeSyncPacket::execute);
        registrar.playBidirectional(PhoenixArrowSyncPacket.TYPE, PhoenixArrowSyncPacket.STREAM_CODEC, PhoenixArrowSyncPacket::execute);
    }

    public void registerCapabilities() {
        ItemStorage.SIDED.registerForBlocks((level, pos, state, blockEntity, side) -> {
            final TreasureChestBlockEntity entity = (TreasureChestBlockEntity)blockEntity;
            if (!(state.method_26204() instanceof class_2281)) {
                return new WrappedInventoryStorage(this, InventoryStorage.of((class_1263)entity, null)){

                    public boolean supportsExtraction() {
                        return entity.getLocked();
                    }
                };
            }
            class_1263 inv = class_2281.method_17458((class_2281)((class_2281)state.method_26204()), (class_2680)state, (class_1937)level, (class_2338)pos, (boolean)true);
            return InventoryStorage.of((class_1263)(inv == null ? entity : inv), null);
        }, new class_2248[]{(class_2248)AetherBlocks.TREASURE_CHEST.get()});
        ItemStorage.SIDED.registerForBlockEntity(InventoryStorage::of, AetherBlockEntityTypes.INCUBATOR.get());
    }

    public void registerDataMaps(RegisterDataMapTypesEvent event) {
        event.register(AetherDataMaps.ALTAR_FUEL);
        event.register(AetherDataMaps.FREEZER_FUEL);
        event.register(AetherDataMaps.INCUBATOR_FUEL);
    }

    public void packSetup(AddPackFindersEvent event) {
        this.setupReleasePack(event);
        this.setupBetaPack(event);
        this.setupCTMFixPack(event);
        this.setupTipsPack(event);
        this.setupColorblindPack(event);
        this.setupTooltipsPack(event);
        this.setupAccessoriesPack(event);
        this.setupAccessoriesOverridePack(event);
        this.setupTemporaryFreezingPack(event);
        this.setupRuinedPortalPack(event);
    }

    private void setupReleasePack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/classic_125").orElseThrow();
            this.createCombinedPack(event, resourcePath, "builtin/aether_125_art", "pack.aether.125.title", "pack.aether.125.description");
        }
    }

    private void setupBetaPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/classic_b173").orElseThrow();
            this.createCombinedPack(event, resourcePath, "builtin/aether_b173_art", "pack.aether.b173.title", "pack.aether.b173.description");
        }
    }

    private void createCombinedPack(AddPackFindersEvent event, Path sourcePath, String name, String title, String description) {
        class_9224 locationInfo = new class_9224(name, (class_2561)class_2561.method_43471((String)title), class_5352.field_25348, Optional.empty());
        Path baseResourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/classic_base").orElseThrow();
        class_3259 basePack = new class_3259(locationInfo, baseResourcePath);
        class_3259 pack = new class_3259(locationInfo, sourcePath);
        List<class_3259> mergedPacks = List.of(pack, basePack);
        CombinedPackResources.CombinedResourcesSupplier resourcesSupplier = new CombinedPackResources.CombinedResourcesSupplier(new class_3272((class_2561)class_2561.method_43471((String)description), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty()), mergedPacks, sourcePath);
        class_3288.class_7679 metadata = class_3288.method_45274((class_9224)locationInfo, (class_3288.class_7680)resourcesSupplier, (int)class_155.method_16673().method_48017(class_3264.field_14188));
        if (metadata != null) {
            event.addRepositorySource(source -> source.accept(new class_3288(locationInfo, resourcesSupplier, metadata, new class_9225(false, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupCTMFixPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188 && FabricLoader.getInstance().isModLoaded("ctm")) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/ctm_fix").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.ctm.description"), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_ctm_fix", (class_2561)class_2561.method_43471((String)"pack.aether.ctm.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(true, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupTipsPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188 && FabricLoader.getInstance().isModLoaded("tipsmod") && ((Boolean)AetherConfig.STARTUP.enable_trivia.get()).booleanValue()) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/tips").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.tips.description"), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_tips", (class_2561)class_2561.method_43471((String)"pack.aether.tips.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(false, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupColorblindPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/colorblind").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.colorblind.description"), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_colorblind", (class_2561)class_2561.method_43471((String)"pack.aether.colorblind.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(false, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupTooltipsPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14188) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/tooltips").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.tooltips.description"), class_155.method_16673().method_48017(class_3264.field_14188), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_tooltips", (class_2561)class_2561.method_43471((String)"pack.aether.tooltips.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(false, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupImmersivePortalsPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190 && FabricLoader.getInstance().isModLoaded("immersive_portals_core") && ((Boolean)AetherConfig.COMMON.enable_immersive_portals_compatibility.get()).booleanValue()) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/imm_ptl_compat").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.imm_ptl_compat.description"), class_155.method_16673().method_48017(class_3264.field_14190), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_imm_ptl_compat", (class_2561)class_2561.method_43471((String)"pack.aether.imm_ptl_compat.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(true, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupAccessoriesPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190 && !((Boolean)AetherConfig.COMMON.use_default_accessories_menu.get()).booleanValue()) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/accessories").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.aether_accessories.description"), class_155.method_16673().method_48017(class_3264.field_14190), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_accessories", (class_2561)class_2561.method_43471((String)"pack.aether.aether_accessories.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(true, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupAccessoriesOverridePack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190 && ((Boolean)AetherConfig.COMMON.use_default_accessories_menu.get()).booleanValue()) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/accessories_override").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.default_accessories.description"), class_155.method_16673().method_48017(class_3264.field_14190), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_accessories_override", (class_2561)class_2561.method_43471((String)"pack.aether.default_accessories.title"), class_5352.field_25348, Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(true, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupTemporaryFreezingPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/temporary_freezing").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.freezing.description"), class_155.method_16673().method_48017(class_3264.field_14190), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_temporary_freezing", (class_2561)class_2561.method_43471((String)"pack.aether.freezing.title"), Aether.create(Aether.decorateWithSource("pack.source.builtin"), (Boolean)AetherConfig.COMMON.add_temporary_freezing_automatically.get()), Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(false, class_3288.class_3289.field_14280, false))));
        }
    }

    private void setupRuinedPortalPack(AddPackFindersEvent event) {
        if (event.getPackType() == class_3264.field_14190) {
            Path resourcePath = (Path)((ModContainer)FabricLoader.getInstance().getModContainer(MODID).orElseThrow()).findPath("packs/ruined_portal").orElseThrow();
            class_3272 metadata = new class_3272((class_2561)class_2561.method_43471((String)"pack.aether.ruined_portal.description"), class_155.method_16673().method_48017(class_3264.field_14190), Optional.empty());
            event.addRepositorySource(source -> source.accept(new class_3288(new class_9224("builtin/aether_ruined_portal", (class_2561)class_2561.method_43471((String)"pack.aether.ruined_portal.title"), Aether.create(Aether.decorateWithSource("pack.source.builtin"), (Boolean)AetherConfig.COMMON.add_ruined_portal_automatically.get()), Optional.empty()), (class_3288.class_7680)new class_3259.class_8619(resourcePath), new class_3288.class_7679(metadata.comp_1580(), class_3281.field_14224, class_7699.method_45397(), List.of()), new class_9225(false, class_3288.class_3289.field_14280, false))));
        }
    }

    public void eventSetup() {
        AccessoryAbilityListener.listen();
        ArmorAbilityListener.listen();
        ToolAbilityListener.listen();
        WeaponAbilityListener.listen();
        AetherPlayerListener.listen();
        AetherTimeListener.listen();
        DimensionListener.listen();
        EntityListener.listen();
        PerkListener.listen();
        RecipeListener.listen();
        CommandRegistrationCallback.EVENT.register(AetherCommands::registerCommands);
        ReloadListeners.reloadListenerSetup(ResourceManagerHelper.get((class_3264)class_3264.field_14190));
        ItemAttributeModifierHelper.ON_MODIFICATION.register(ZaniteSwordItem::onModifyAttributes);
        ServerLivingEntityEvents.AFTER_DAMAGE.register((entity, source, baseDamageTaken, damageTaken, blocked) -> FlamingSwordItem.onLivingDamage(entity, source));
        LivingEntityEvents.ON_DAMAGE.register((entity, source, originalDamage, newDamage) -> {
            HolySwordItem.onLivingDamage(entity, source, newDamage);
            PigSlayerItem.onLivingDamage(entity, source, newDamage);
        });
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register(AetherCreativeTabs::buildCreativeModeTabs);
        AetherEntityTypes.registerSpawnPlacements();
        AetherEntityTypes.registerEntityAttributes();
        AbilityHooks.ToolHooks.STRIPPABLES.forEach(StrippableBlockRegistry::register);
        AbilityHooks.ToolHooks.FLATTENABLES.forEach((block, flattenedBlock) -> FlattenableBlockRegistry.register((class_2248)block, (class_2680)flattenedBlock.method_9564()));
        AbilityHooks.ToolHooks.TILLABLES.forEach((block, tilledBlock) -> TillableBlockRegistry.register((class_2248)block, ctx -> ctx.method_8045().method_8320(ctx.method_8037().method_10084()).method_26215(), (class_2680)tilledBlock.method_9564()));
    }

    static class_5352 create(final UnaryOperator<class_2561> decorator, final boolean shouldAddAutomatically) {
        return new class_5352(){

            public class_2561 method_45282(class_2561 component) {
                return (class_2561)decorator.apply(component);
            }

            public boolean method_45279() {
                return shouldAddAutomatically;
            }
        };
    }

    private static UnaryOperator<class_2561> decorateWithSource(String translationKey) {
        class_5250 component = class_2561.method_43471((String)translationKey);
        return arg_0 -> Aether.lambda$decorateWithSource$16((class_2561)component, arg_0);
    }

    private void registerDispenserBehaviors() {
        class_2315.method_10009((class_1935)((class_1935)AetherItems.GOLDEN_DART.get()), (class_2357)new class_2965((class_1792)AetherItems.GOLDEN_DART.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.POISON_DART.get()), (class_2357)new class_2965((class_1792)AetherItems.POISON_DART.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.ENCHANTED_DART.get()), (class_2357)new class_2965((class_1792)AetherItems.ENCHANTED_DART.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.LIGHTNING_KNIFE.get()), (class_2357)new class_2965((class_1792)AetherItems.LIGHTNING_KNIFE.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.HAMMER_OF_KINGBDOGZ.get()), (class_2357)AetherDispenseBehaviors.DISPENSE_KINGBDOGZ_HAMMER_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_WATER_BUCKET.get()), (class_2357)AetherDispenseBehaviors.SKYROOT_BUCKET_DISPENSE_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_BUCKET.get()), (class_2357)AetherDispenseBehaviors.SKYROOT_BUCKET_PICKUP_BEHAVIOR);
        class_2315.method_10009((class_1935)((class_1935)AetherItems.AMBROSIUM_SHARD.get()), new DispenseUsableItemBehavior<AmbrosiumRecipe>(AetherRecipeTypes.AMBROSIUM_ENCHANTING.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SWET_BALL.get()), new DispenseUsableItemBehavior<SwetBallRecipe>(AetherRecipeTypes.SWET_BALL_CONVERSION.get()));
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_BOAT.get()), (class_2357)new SkyrootBoatDispenseBehavior());
        class_2315.method_10009((class_1935)((class_1935)AetherItems.SKYROOT_CHEST_BOAT.get()), (class_2357)new SkyrootBoatDispenseBehavior(true));
    }

    private void registerCauldronInteractions() {
        class_5620.field_27775.comp_1982().put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_27777.comp_1982().put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_28011.comp_1982().put((class_1792)AetherItems.SKYROOT_WATER_BUCKET.get(), AetherCauldronInteractions.FILL_WATER);
        class_5620.field_27775.comp_1982().put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_27777.comp_1982().put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_28011.comp_1982().put((class_1792)AetherItems.SKYROOT_POWDER_SNOW_BUCKET.get(), AetherCauldronInteractions.FILL_POWDER_SNOW);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.SKYROOT_BUCKET.get(), AetherCauldronInteractions.EMPTY_WATER);
        class_5620.field_28011.comp_1982().put((class_1792)AetherItems.SKYROOT_BUCKET.get(), AetherCauldronInteractions.EMPTY_POWDER_SNOW);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.LEATHER_GLOVES.get(), class_5620.field_27782);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.RED_CAPE.get(), AetherCauldronInteractions.CAPE);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.BLUE_CAPE.get(), AetherCauldronInteractions.CAPE);
        class_5620.field_27776.comp_1982().put((class_1792)AetherItems.YELLOW_CAPE.get(), AetherCauldronInteractions.CAPE);
    }

    private static /* synthetic */ class_2561 lambda$decorateWithSource$16(class_2561 component, class_2561 name) {
        return class_2561.method_43469((String)"pack.nameAndSource", (Object[])new Object[]{name, component}).method_27692(class_124.field_1080);
    }
}

